#define NONORMAL
#define LIGHTING
#include "InventorBasicEffectDx10.fxh"

struct VSPos
{
	float3 Pos			: Position;
};

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------

VSOutput VS_Pos( VSPos Input)
{
	VSOutput Out = (VSOutput) 0;
	float4 LocalPos = float4(Input.Pos,1.0f);

	Out.Pos = mul(LocalPos, g_matWorldViewProj);

	float3 ViewPos = mul(LocalPos, g_matWorldView);    //position in view space
	if(g_enabledLight)
	{
		float Opacity = g_Misc.y;
		TripleColor Color = CalcLightingAmb(Input.Pos,g_Emissive, g_Ambient,Opacity);
		Out.ColorD = Color.Diffuse;
	}else
	{
		Out.ColorD = g_Emissive;
	}
	Out.ColorD.w = g_Misc.y;

#ifdef DIFFUSE_TEXTURE
	Out.Tex += float4(Input.Pos*(g_texCoordType == TEX_COORD_POSITION), 1.0f);
	Out.Tex += float4(ViewPos * (g_texCoordType == TEX_COORD_CAMERASPACEPOSITION), 0);
	Out.Tex = mul(Out.Tex, g_matDiffTex);
#endif

	if(g_fogEnabled)
	{
		Out.FogFactor =	CalcFogFactor(ViewPos.z);
	}
 	//Apply user specified clipping
    	Out.ClipplaneDist0.x = Out.ClipplaneDist0.y = Out.ClipplaneDist0.z =Out.ClipplaneDist0.w = 1;
    	Out.ClipplaneDist1.x = Out.ClipplaneDist1.y = Out.ClipplaneDist1.z =Out.ClipplaneDist1.w = 1;
    	if( g_bClippingEnable )
    	{
		CalcClipping(LocalPos, Out);
    	}

#ifdef FIX_Z
	Out.Pos.z = 0.205f;
#endif
	return Out;
}
//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------

float4 PS_Pos( VSOutput Input ) : SV_Target
{
#ifdef DIFFUSE_TEXTURE
	CalcDiffuseTexture(Input);
#endif
	if(Input.ColorD.a < g_Misc.w)
		discard;
	float4 Color = saturate(Input.ColorD + Input.ColorS);
if(g_fogEnabled)
	return Input.FogFactor * Color + (1.0 - Input.FogFactor) * g_fogColor;
else
	return Color;
}

//--------------------------------------------------------------------------------------
// Techniques
//--------------------------------------------------------------------------------------

technique10 Pos
{
    pass P0
    {   
	SetVertexShader( CompileShader( vs_4_0, VS_Pos()) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, PS_Pos()) );
    }
}